local assets =
{
	Asset("ANIM", "anim/knightarmor.zip"),
}

local function OnBlocked(owner) 
    owner.SoundEmitter:PlaySound("dontstarve/wilson/hit_armour")
end

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_body", "knightarmor", "knightarmor")
    inst:ListenForEvent("blocked", OnBlocked, owner)
end

local function onunequip(inst, owner) 
    owner.AnimState:ClearOverrideSymbol("swap_body")
	inst:RemoveEventCallback("blocked", OnBlocked, owner)
end

local function fn()
	local inst = CreateEntity()
    
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
	--[[
	if IsDLCEnabled(CAPY_DLC) then
		MakeInventoryFloatable(inst, "idle_water", "idle")
    end
    ]]
    inst.AnimState:SetBank("knightarmor")
    inst.AnimState:SetBuild("knightarmor")
    inst.AnimState:PlayAnimation("anim")
    
    inst:AddTag("ruins")
	inst:AddTag("metal")
    
    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.foleysound = "dontstarve/movement/foley/metalarmour"
	inst.components.inventoryitem.atlasname = "images/inventoryimages/knightarmor.xml"
	
    inst:AddComponent("armor")
    inst.components.armor:InitCondition(TUNING.ARMORRUINS*.65, .80)

    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BODY
	
	local ARMORSLOW = 0.9

	if IsDLCEnabled(CAPY_DLC) then
		ARMORSLOW = -0.1
	end
	inst.components.equippable.walkspeedmult = ARMORSLOW

    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
    
    return inst
end




return Prefab( "common/inventory/knightarmor", fn, assets) 
